FileLeg = 'Right Figures with GD MedandTM/Legend';
algo_names = {'GD w/o Filter','GD with Median','GD with Trimmed Mean','Oracle GD'};
marker_list = ['<', '+', 'x', '<'];
cl = {'[0.4940 0.1840 0.5560]','[0.4660 0.6740 0.1880]','[0.3010 0.7450 0.9330]','[0 0.4470 0.7410]'};
algo_len = length(algo_names);
x = 1:4;
y = NaN;
legend_cell = algo_names;
figure;
for iter_algo = 1: algo_len
    plot(x, y .* x, [marker_list(iter_algo)],'LineStyle','-','DisplayName', legend_cell{iter_algo},'Color',cl{iter_algo},'LineWidth',3,'MarkerSize',14);
    hold on;
end
hold off 
set(gcf,'Position',[0,0,1024,1024]);
legend_handle = legend('Orientation','horizontal');
set(gcf,'Position',(get(legend_handle,'Position')...
    .*[0, 0, 1, 1].*get(gcf,'Position')));
set(legend_handle,'Position',[0,0,1,1]);
set(gcf, 'Position', get(gcf,'Position') + [500, 400, 0, 0]);
savefig(FileLeg); saveas(gca, FileLeg, 'epsc');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FileLeg = 'Right Figures with GD MedandTM/Legend_SGDGD';
algo_names = {'SGD with Median','GD with Median','Oracle SGD','Oracle GD'};
marker_list = ['x', '+', 's', '<'];
cl = {'[0.8500 0.3250 0.0980]','[0.4660 0.6740 0.1880]','[0.6350 0.0780 0.1840]','[0 0.4470 0.7410]'};
algo_len = length(algo_names);
x = 1:4;
y = NaN;
legend_cell = algo_names;
figure;
for iter_algo = 1: algo_len
    plot(x, y .* x, [marker_list(iter_algo)],'LineStyle','-','DisplayName', legend_cell{iter_algo},'Color',cl{iter_algo},'LineWidth',3,'MarkerSize',14);
    hold on;
end
hold off 
set(gcf,'Position',[0,0,1024,1024]);
legend_handle = legend('Orientation','horizontal');
set(gcf,'Position',(get(legend_handle,'Position')...
    .*[0, 0, 1, 1].*get(gcf,'Position')));
set(legend_handle,'Position',[0,0,1,1]);
set(gcf, 'Position', get(gcf,'Position') + [500, 400, 0, 0]);
savefig(FileLeg); saveas(gca, FileLeg, 'epsc');
